function s=Mitchell(A,B)

%
% s=Mitchell(A,B)
%
% To compute the similarity between two IT2 FSs A and B using Mitchell's
% method:
%
% H. B. Mitchell, "Pattern recognition using type-II fuzzy sets,"
% Information Sciences, vol. 170, no. 2-4, pp. 409--418, 2005.
%
% Dongrui WU (dongruiw@usc.edu), 7/9/2008
%
% A, B: IT2 FSs each defined by nine parameters (see Fig. 1 in Readme.doc)


s=0;
if A(4)<=B(1) | B(4)<=A(1)  %% A and B are disjoint
    return;
else
    N=200; % number of discretizations
    minX=min(A(1),B(1)); % the range
    maxX=max(A(4),B(4));
    X=linspace(minX,maxX,N);

    lowerA=mg(X,A(5:8),[0 A([9 9]) 0]);
    upperA=mg(X,A(1:4));
    lowerB=mg(X,B(5:8),[0 B([9 9]) 0]);
    upperB=mg(X,B(1:4));

    %% Find the embedded T1 FSs
    M=10; %% number of embedded T1 FSs
    thetaA=zeros(M,N);
    thetaB=zeros(M,N);
    for i=1:M
        thetaA(i,:)=lowerA+rand(1,N).*(upperA-lowerA);
        thetaB(i,:)=lowerB+rand(1,N).*(upperB-lowerB);
    end

    for i=1:M
        for j=1:M
            s=s+sum(min([thetaA(i,:);thetaB(j,:)],[],1))/...
                sum(max([thetaA(i,:);thetaB(j,:)],[],1));
        end
    end
    s=s/M^2;
end